<%@ LANGUAGE="VBScript" %>

<% '***************************************************************************
   '* ASP Football Pool                                                       *
   '*                                                                         *
   '* Copyright 2000 by Mike Hall                                             *
   '* Please see http://www.brainjar.com for documentation and terms of use.  *
   '***************************************************************************
%>

<!-- #include file="protect.inc" -->
<!-- #include file="common.inc" -->
<!-- #include file="header.inc" -->

<% 'If not the Administrator, redirect to login page.

   if Session("PoolUsername") <> ADMIN_USERNAME then
     Response.Redirect("login.asp")
   end if

   'Open the database.

   call OpenDB()

   'Default to current week if no valid number was given.

   week = Request("week")
   if not IsNumeric(week) then
     week = CurrentWeek()
   else
     week = Round(week)
     if week < 1 or week > NumberOfWeeks() then
       week = CurrentWeek()
     end if
   end if

   'If there's form data, check it.

   errorFlag = false
   if Request.ServerVariables("Content_Length") > 0 then
     for i = 1 to NumberOfGames(week)
       vscore = Trim(Request.Form("vscore-" & i))
       hscore = Trim(Request.Form("hscore-" & i))
       ot = Request.Form("ot-" & i)
       if ot <> "" or vscore <> "" or hscore <> "" then
         if not IsNumeric(vscore) or not IsNumeric(hscore) then
           call ErrorMessage("Scores must be numeric, changes not accepted.")
           errorFlag = true
         end if
       end if
     next

     'If no errors, update scores where given and set result field.

     if not errorFlag then
       for i = 1 to NumberOfGames(week)
         vscore = Trim(Request.Form("vscore-" & i))
         hscore = Trim(Request.Form("hscore-" & i))
         ot = Request.Form("ot-" & i)
         if ot = "" then
           ot = false
         end if
         if vscore <> "" and hscore <> "" then
           vscore = CInt(vscore)
           hscore = CInt(hscore)
           if vscore > hscore then
             result = Request.Form("visitor-" & i)
           elseif hscore > vscore then
             result = Request.Form("home-" & i)
           else
             result = TIE_STR
           end if
         else
           result = ""
         end if
         if Request.Form("id-" & i) <> "" and _
            Trim(Request.Form("vscore-" & i)) <> "" and _
            Trim(Request.Form("hscore-" & i)) <> "" then
           sql = "update Schedule set" _
              & " VisitorScore = " & Request.Form("vscore-" & i) & "," _
              & " HomeScore    = " & Request.Form("hscore-" & i) & "," _
              & " OT           = " & ot & "," _
              & " Result       = '" & result & "'" _
              & " where GameID = " & Request.Form("id-" & i)
           set rs = DbConn.Execute(sql)
         end if
       next

       'Updates done, redirect to weekly schedule.

       Response.Redirect("weekly.asp?week=" & week)
     end if

   end if

   'Display weekly schedule. %>

<form action="<% = Request.ServerVariables("SCRIPT_NAME") %>" method="post">
<input name="week" type="hidden" value="<% = week %>">
<p><table class="formatted" cellpadding=0 cellspacing=0>
<tr><th colspan=8>Week <% = week %></th></tr>
<% sql = "select * from Schedule"_ 
      & " where Week = " & week _
      & " order by Date, Time, VisitorID"
   set rs = DbConn.Execute(sql)
   if not (rs.BOF and rs.EOF) then
     i = 1
     do while not rs.EOF
       if Round(i / 2) * 2 <> i then %>
<tr align=right>
<%     else %>
<tr align=right class="alt">
<%     end if %>
  <td>
    <input name="id-<% = i %>" type="hidden" value="<% = rs.Fields("GameID").Value %>">
    <input name="visitor-<% = i %>" type="hidden" value="<% = rs.Fields("VisitorID").Value %>">
    <input name="home-<% = i %>" type="hidden" value="<% = rs.Fields("HomeID").Value %>">
    <% = WeekdayName(Weekday(rs.Fields("Date").Value), true) %>&nbsp;
  </td>
  <td><% = FormatDate(rs.Fields("Date").Value) %>&nbsp;</td>
  <td><% = FormatTime(rs.Fields("Time").Value) %>&nbsp;</td>
  <td><% = rs.Fields("VisitorID").Value %>&nbsp;</td>
  <td><input name="vscore-<% = i %>" type="text" value="<% = rs.Fields("VisitorScore").Value %>" size=2></td>
  <td>at <% = rs.Fields("HomeID").Value %>&nbsp;</td>
  <td><input name="hscore-<% = i %>" type="text" value="<% = rs.Fields("HomeScore").Value %>" size=2></td>
<%     if rs.Fields("OT").Value then %>
  <td>OT <input name="ot-<% = i %>" type="checkbox" value="True" checked></td>
<%     else %>
  <td>OT <input name="ot-<% = i %>" type="checkbox" value="True"></td>
<%     end if %>
</tr>
<%     rs.MoveNext
       i = i + 1
     loop %>
<% end if %>
</table></p>

<p><input type="submit" value="Update"></p>

</form>

<% 'List weeks. %>

<p><b>Go to week:</b>
<% for i = 1 to NumberOfWeeks() %>
<a href="<% = Request.ServerVariables("SCRIPT_NAME") %>?week=<% = i %>">
<% = i %></a>&nbsp;
<% next %>
</p>

<!-- #include file="footer.inc" -->
